*Reading in the data;
data LEGISLATORDATA;
    infile 'LegislatorData.txt' dlm=',' lrecl=1800 dsd;
    input HOUSE STATE $ LASTNAME $ PARTY VOTING MONEY PTYXMNY ACRES GSP N_REPS LOBBY LEGISLATOR;
run;

*SAS requires you to first sort your data by your level 1 id;
proc sort data=LEGISLATORDATA;
    by LEGISLATOR;
run;

*Center predictors;
MONEY = MONEY - 13.007514231499044;
ACRES = ACRES - 12.955907020872855;
if (HOUSE = 0) then HOUSE = -1;

*Multilevel model with random intercept;
proc mixed;
    class STATE; *Note that you have to declare your grouping variable as a class variable;
    model VOTING = MONEY / solution;
    random intercept / subject=STATE;

*Multilevel model with random intercept and random slope;
proc mixed;
    class STATE;
    model VOTING = MONEY / solution;
    random intercept MONEY / subject=STATE;

*Multilevel model with random intercept, random slope, non-default covariance matrix, and non-default degrees of freedom estimation;
proc mixed;
    class STATE;
    model VOTING = PARTY / solution ddfm=bw; *You can declare many df estimation methods here using the ddfm= option;
    random intercept PARTY / type=UN subject=STATE; *You can declare many covariance structures here using the type= option;

*Moderated multilevel model with random intercept and a covariate .
proc mixed;
    class STATE;
    model VOTING = HOUSE MONEY|ACRES / solution;
    random intercept / subject=STATE;

*Simple effects testing in multilevel models;
LOWMONEY = MONEY + 18.437599427762795;
HIGHMONEY = MONEY - 18.437599427762795;
LOWACRES = ACRES + 41.562242563739005;
HIGHACRES = ACRES - 41.562242563739005;

*Simple effect of Money for states with low acreage;
proc mixed;
    class STATE;
    model VOTING = HOUSE MONEY|LOWACRES / solution;
    random intercept / subject=STATE;
*Simple effect of Money for states with high acreage;
proc mixed;
    class STATE;
    model VOTING = HOUSE MONEY|HIGHACRES / solution;
    random intercept / subject=STATE;
*Simple effect of Acres for legislators with low campaign contributions;
proc mixed;
    class STATE;
    model VOTING = HOUSE LOWMONEY|ACRES / solution;
    random intercept / subject=STATE;
*Simple effect of Acres for legislators with high campaign contributions;
proc mixed;
    class STATE;
    model VOTING = HOUSE HIGHMONEY|ACRES / solution;
    random intercept / subject=STATE;

*Baseline model to calculate effect size;
proc mixed;
    class STATE;
    model VOTING = / solution;
    random intercept / subject=STATE;

/* Advanced Applications */
*3-level model with random slope.
proc mixed;
    class STATE PARTY;
    model VOTING = MONEY|ACRES / solution;
    random intercept MONEY / subject=PARTY;
    random intercept MONEY / subject=STATE(PARTY);

*Nested Growth Curve Models (HYPOTHETICAL DATA) - Pretend that each vote on all pro-tobacco legislation was recorded (instead of the overall percentage) and the sequential order of each vote was stored in a variable called TIME;
proc mixed;
    class STATE LEGISLATOR;
    model VOTING = MONEY|ACRES|TIME / solution ddfm=bw;
    random intercept TIME / type=UN subject=STATE;
    random intercept TIME / type=UN subject=LEGISLATOR(STATE);
